/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.schedops;

import com.ibm.hwmca.base.util.SimServer;
import com.ibm.hwmca.fw.managed.HMC;
import com.ibm.hwmca.fw.managed.ManagedObject;
import com.ibm.hwmca.fw.managed.ManagedObjectManager;
import com.ibm.hwmca.fw.managed.ObjectId;
import com.ibm.hwmca.fw.persist.Persistable;
import com.ibm.hwmca.fw.persist.PersistenceException;
import com.ibm.hwmca.fw.persist.PersistenceManager;
import com.ibm.hwmca.fw.persist.PersistentData;
import com.ibm.hwmca.fw.schedops.OperationTarget;
import com.ibm.hwmca.fw.schedops.Schedulable;
import com.ibm.hwmca.fw.schedops.Schedule;
import com.ibm.hwmca.fw.task.UserContext;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.Trace;
import java.util.Date;

public class ScheduledOperation
implements Persistable {
    private static final String CLASS_NAME = "[ScheduledOperation] ";
    private static final String TRACE_MASKT = "XTIMxxxT";
    private static final String TRACE_MASKF = "XTIMxxxF";
    private static final String TRACE_MASKD = "XTIMxxxD";
    private static final long CURRENT_VERSION = 1L;
    private static final String PERSISTENCE_NAMESPACE = (class$com$ibm$hwmca$fw$schedops$ScheduledOperation == null ? (class$com$ibm$hwmca$fw$schedops$ScheduledOperation = ScheduledOperation.class$("com.ibm.hwmca.fw.schedops.ScheduledOperation")) : class$com$ibm$hwmca$fw$schedops$ScheduledOperation).getName();
    private static long nextID = 0L;
    private static Object lock = new Object();
    private long uniqueID;
    private String persistenceKey;
    private Date lastExecutionDate;
    private boolean lastExecutionStatus;
    private Date creationDate;
    private Integer creationInterface;
    private LocalizableText creationUserid;
    private LocalizableText creationSourceNetID;
    private LocalizableText creationSourceName;
    private OperationTarget target;
    private Schedulable schedulable;
    private Schedule schedule;
    private Object parms;
    static /* synthetic */ Class class$com$ibm$hwmca$fw$schedops$ScheduledOperation;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ScheduledOperation(OperationTarget target, Schedulable schedulable, Schedule schedule, Object parms) {
        Trace.trace(TRACE_MASKT, "[ScheduledOperation] >> ScheduledOperation()");
        if (target != null && schedulable != null && schedule != null) {
            Object object = lock;
            synchronized (object) {
                this.uniqueID = ++nextID;
            }
            this.target = target;
            this.schedulable = schedulable;
            this.schedule = schedule;
            this.parms = parms;
            UserContext context = UserContext.getCurrentUserContext();
            this.creationDate = new Date();
            this.creationUserid = new LocalizableText(context.getUserid());
            try {
                byte[] netid = SimServer.getSimServer().readSim(6);
                this.creationSourceNetID = new LocalizableText(new String(netid, 0, 8));
            }
            catch (Exception e) {
                Trace.trace(TRACE_MASKF, "[ScheduledOperation]    Exception caught while reading SIM field...");
                Trace.trace(TRACE_MASKF, e);
                this.creationSourceNetID = new LocalizableText("????");
            }
            this.creationSourceName = new LocalizableText(HMC.getHMC().getUIInfo().getName());
            switch (context.getType()) {
                case 1: {
                    this.creationInterface = new Integer(41227);
                    break;
                }
                case 2: {
                    this.creationInterface = new Integer(41225);
                    break;
                }
                case 0: 
                case 3: {
                    this.creationInterface = new Integer(41229);
                    break;
                }
                default: {
                    this.creationInterface = new Integer(0);
                    break;
                }
            }
        } else {
            throw new IllegalArgumentException("Illegal null value ");
        }
        Trace.trace(TRACE_MASKT, "[ScheduledOperation] << ScheduledOperation()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ScheduledOperation(PersistentData persistentData, String persistenceKey) throws PersistenceException {
        Trace.trace(TRACE_MASKT, "[ScheduledOperation] <> ScheduledOperation( PersistentData )");
        PersistedData data = (PersistedData)persistentData;
        PersistenceManager pm = PersistenceManager.getPersistenceManager();
        if (data.version != 1L) throw new PersistenceException("Incompatible versions");
        this.persistenceKey = persistenceKey;
        this.creationDate = (Date)pm.containedFormToObject(data.creationDate);
        this.creationInterface = (Integer)pm.containedFormToObject(data.creationInterface);
        this.creationUserid = (LocalizableText)pm.containedFormToObject(data.creationUserid);
        this.creationSourceNetID = (LocalizableText)pm.containedFormToObject(data.creationSourceNetID);
        this.creationSourceName = (LocalizableText)pm.containedFormToObject(data.creationSourceName);
        if (data.lastExecutionDate != null) {
            this.lastExecutionDate = (Date)pm.containedFormToObject(data.lastExecutionDate);
        }
        this.lastExecutionStatus = data.lastExecutionStatus;
        this.schedule = (Schedule)pm.containedFormToObject(data.schedule);
        this.schedulable = (Schedulable)pm.containedFormToObject(data.schedulable);
        if (data.parms != null) {
            this.parms = pm.containedFormToObject(data.parms);
        }
        ObjectId moID = (ObjectId)pm.containedFormToObject(data.targetID);
        ManagedObject mo = (ManagedObject)ManagedObjectManager.getManagedObjectManager().get(moID);
        if (mo == null) {
            if (!HMC.getHMC().getObjectId().equals(moID)) throw new IllegalStateException("Managed Object not found");
            mo = HMC.getHMC();
        }
        this.target = (OperationTarget)((Object)mo);
        Object object = lock;
        synchronized (object) {
            this.uniqueID = ++nextID;
        }
        Trace.trace(TRACE_MASKF, "[ScheduledOperation] \t" + this.toString());
    }

    public final OperationTarget getOperationTarget() {
        return this.target;
    }

    public final Schedulable getSchedulable() {
        return this.schedulable;
    }

    public final Schedule getSchedule() {
        return this.schedule;
    }

    public final Object getOperationParameters() {
        return this.parms;
    }

    public Date getCreationDate() {
        return this.creationDate;
    }

    public int getCreationInterface() {
        return this.creationInterface;
    }

    public LocalizableText getCreationUserid() {
        return this.creationUserid;
    }

    public LocalizableText getCreationSourceNetID() {
        return this.creationSourceNetID;
    }

    public LocalizableText getCreationSourceName() {
        return this.creationSourceName;
    }

    public Date getLastExecutionDate() {
        return this.lastExecutionDate;
    }

    public boolean getLastExecutionStatus() {
        return this.lastExecutionStatus;
    }

    public static String getPersistenceNameSpace() {
        return PERSISTENCE_NAMESPACE;
    }

    public void setCreationDate(Date date) {
        this.creationDate = new Date(date.getTime());
    }

    public void setCreationInterface(int intf) {
        this.creationInterface = new Integer(intf);
    }

    public void setCreationUserid(String userid) {
        this.creationUserid = new LocalizableText(userid);
    }

    public void setCreationSourceNetID(String netid) {
        this.creationSourceNetID = new LocalizableText(netid);
    }

    public void setCreationSourceName(String name) {
        this.creationSourceName = new LocalizableText(name);
    }

    public void setLastExecutionDate(Date date) {
        this.lastExecutionDate = new Date(date.getTime());
    }

    public void setLastExecutionStatus(boolean status) {
        this.lastExecutionStatus = status;
    }

    public long getUniqueID() {
        return this.uniqueID;
    }

    public synchronized void persist() throws PersistenceException {
        Trace.trace(TRACE_MASKT, "[ScheduledOperation] >> persist()");
        PersistenceManager pm = PersistenceManager.getPersistenceManager();
        if (this.persistenceKey == null) {
            this.persistenceKey = pm.writeChild(PERSISTENCE_NAMESPACE, this);
        } else {
            pm.write(this.persistenceKey, this);
        }
        Trace.trace(TRACE_MASKT, "[ScheduledOperation] << persist()");
    }

    public synchronized void unpersist() throws PersistenceException {
        Trace.trace(TRACE_MASKT, "[ScheduledOperation] >> unpersist()");
        PersistenceManager pm = PersistenceManager.getPersistenceManager();
        if (this.persistenceKey != null) {
            pm.delete(this.persistenceKey);
        }
        Trace.trace(TRACE_MASKT, "[ScheduledOperation] << unpersist()");
    }

    public PersistentData getPersistentData() {
        PersistenceManager pm = PersistenceManager.getPersistenceManager();
        PersistedData data = new PersistedData();
        data.version = 1L;
        data.creationDate = pm.objectToContainedForm(this.creationDate);
        data.creationInterface = pm.objectToContainedForm(this.creationInterface);
        data.creationUserid = pm.objectToContainedForm(this.creationUserid);
        data.creationSourceNetID = pm.objectToContainedForm(this.creationSourceNetID);
        data.creationSourceName = pm.objectToContainedForm(this.creationSourceName);
        if (this.lastExecutionDate != null) {
            data.lastExecutionDate = pm.objectToContainedForm(this.lastExecutionDate);
        }
        data.lastExecutionStatus = this.lastExecutionStatus;
        data.targetID = pm.objectToContainedForm(((ManagedObject)((Object)this.target)).getObjectId());
        data.schedule = pm.objectToContainedForm(this.schedule);
        data.schedulable = pm.objectToContainedForm(this.schedulable);
        if (this.parms != null) {
            data.parms = pm.objectToContainedForm(this.parms);
        }
        return data;
    }

    public boolean isUpgradeData() {
        return true;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("ScheduledOperation=[");
        buffer.append("Target=");
        buffer.append(this.target.getDisplayableName());
        buffer.append("; Operation=");
        buffer.append(this.schedulable.getDescriptor().getDescription());
        buffer.append("; ");
        buffer.append(this.schedule);
        buffer.append("; Parms=");
        buffer.append(this.parms);
        buffer.append("]");
        return buffer.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class PersistedData
    implements PersistentData {
        private static final long serialVersionUID = -1L;
        public long version;
        public Object creationDate;
        public Object creationInterface;
        public Object creationUserid;
        public Object creationSourceNetID;
        public Object creationSourceName;
        public Object lastExecutionDate;
        public boolean lastExecutionStatus;
        public Object targetID;
        public Object schedulable;
        public Object schedule;
        public Object parms;

        private PersistedData() {
        }
    }
}

